% this generates coordinates for Lazi object
% sizes in um
clear all
doElectrode=false;


% make Hall bar, with contact or not

%{
XLineWidth=2;  %um
XLineLength=10;  %um

YLineWidth=2; %um
YLineLength= 40; %um

ContactWidth=5; %30


ElectrodeOffset=0;  % offset 0.5

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Lx=XLineLength/2; dLy=XLineWidth/2;
Ly=YLineLength/2; dLx=YLineWidth/2;

MyObject=[-Lx -dLy; -dLx -dLy; -dLx -Ly; dLx -Ly; dLx -dLy; Lx -dLy; Lx dLy; dLx dLy; dLx Ly; -dLx Ly; -dLx dLy; -Lx dLy];
ObjectsHall{1}=MyObject;
% contacts
%top; to left
L=-20;
R=YLineWidth/2+0.5;
B=YLineLength/2;
T=YLineLength/2+ContactWidth;
B1=B+ElectrodeOffset;

%ObjectsHall{2}=[R T;L T;L B;R B];
ObjectsElec{1}=[R T;L T;L B1;R B1];
%but; to right
R=20;
L=-YLineWidth/2-0.5;
T=-YLineLength/2;
B=-YLineLength/2-ContactWidth;
T1=T-ElectrodeOffset;

%ObjectsHall{3}=[R T;L T;L B;R B];
ObjectsElec{2}=[R T1;L T1;L B;R B];

%left; to down
T=XLineWidth/2+0.5;
B=-10;
R=-XLineLength/2;
L=-XLineLength/2-ContactWidth;
R1=R-ElectrodeOffset;
B2=B/2;
R2=R-5;
R12=R1-5;

%ObjectsHall{4}=[R T;L T;L B;R2 B;R B2];
ObjectsElec{3}=[R1 T;L T;L B;R12 B;R1 B2];
%right; to up
B=-XLineWidth/2-0.5;
T=10;
L=XLineLength/2;
R=XLineLength/2+ContactWidth;
L1=L+ElectrodeOffset;
T2=5;
L2=L+5;
L12=L1+5;

%ObjectsHall{5}=[R T;L2 T;L T2;L B;R B];
ObjectsElec{4}=[R T;L12 T;L1 T2;L1 B;R B];




%}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% make Hall bar for quoter
%{
% distance between electrode 24
XLineWidth=2.2;  %um 20 between electrodes
XLineLength=21;  %um 30

YLineWidth=2.2; %um
YLineLength= 21; %um30

OffsetX=5.5;
OffsetY=5.5;





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Lx=XLineLength/2; dLy=XLineWidth/2;
Ly=YLineLength/2; dLx=YLineWidth/2;

MyObject=[-Lx -dLy-OffsetY; -dLx-OffsetX -dLy-OffsetY; -dLx-OffsetX -Ly; dLx-OffsetX -Ly; dLx-OffsetX -dLy-OffsetY; Lx -dLy-OffsetY; Lx dLy-OffsetY; dLx-OffsetX dLy-OffsetY; dLx-OffsetX Ly; -dLx-OffsetX Ly; -dLx-OffsetX dLy-OffsetY; -Lx dLy-OffsetY];
ObjectsHall{1}=MyObject;
%}

% calculate ellipse
% {
el_size=2; %um
el_ratio=1.4;
    
   fi=4:4:360;
    for j=1:length(fi)
    MyMag(j,1)=el_size*0.5*cos(fi(j)*pi/180)*el_ratio;
    MyMag(j,2)=el_size*0.5*sin(fi(j)*pi/180)/el_ratio;
    dydx=MyMag(j,1)/MyMag(j,2)/el_ratio^2;
    Norm=sqrt(1+dydx^2);
    EllipNorm(j,1)=dydx/Norm;EllipNorm(j,2)=1/Norm;
       if fi(j)>180
      EllipNorm(j,2)=-EllipNorm(j,2);
      EllipNorm(j,1)=-EllipNorm(j,1);
       end
    end
      ObjectsHall{1}=MyMag;
      doElectrode=false;
%}




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%% save data
%Hall
fileName='E:\reticles\11 reticle\LasiHall.txt';
    fid = fopen(fileName,'w');

    for jj=1:length(ObjectsHall)
        MyObject=ObjectsHall{jj};
fprintf(fid,['obj p ' ' \n']);
for j=1:length(MyObject(:,1))
    fprintf(fid,['add ' num2str(MyObject(j,1))  ' , '  num2str(MyObject(j,2)) '  \n']);    
end
fprintf(fid,['add ' num2str(MyObject(1,1))  ' , '  num2str(MyObject(1,2)) '  \n']);
fprintf(fid,['aput ' ' \n']);
    end
fclose(fid); 

%Electrodes
if doElectrode

fileName='E:\reticles\11 reticle\LasiElec.txt';
    fid = fopen(fileName,'w');

    for jj=1:length(ObjectsElec)
        MyObject=ObjectsElec{jj};
fprintf(fid,['obj p ' ' \n']);
for j=1:length(MyObject(:,1))
    fprintf(fid,['add ' num2str(MyObject(j,1))  ' , '  num2str(MyObject(j,2)) '  \n']);    
end
fprintf(fid,['add ' num2str(MyObject(1,1))  ' , '  num2str(MyObject(1,2)) '  \n']);
fprintf(fid,['aput ' ' \n']);
    end
fclose(fid); 

end




